% clear;
% close all;

% this for loop can be released to cycle over solid angles too
% for reali = 15.15


lookuptable_1 = zeros(400000,8);

% number of samples required
numsamp = 30;

% directions of the viewing rays
thetas = [0:pi/(2*numsamp):pi/2];

% step for each direction
dtheta = 90/numsamp;
icount = 1;

% count variable
mystuffcount = 1;

% stepping through the template height (u), template width (d) and two
% refractive indices
% see paper for variable names
ustep = 1;
dstep = 1;
nstep = 0.05;
n2step = 0.05;

% loop for the template height
for u = 0.1:ustep:12
% for u = 5.1
    
    u

% loop for the template width
for d = 0.1:dstep:12
% for d = 1.1

% loop over lenslet index of refraction
% for n = 1.4
for n = 1:nstep:2
    
% max cost
maxcost = realomega/5;

if maxcost == realomega
    input('omega cannot equal maxcost');
end

% pixel pitch
step = 0.0052;

compstep = 0.001;

% max step
% maxstep = 100;

% loop over slab index of refraction
for n2 = 1:n2step:(n-0.01)
% for n2 = 1.2

count = 1;

% loop over the viewing direction
for th = 1:length(thetas)
    
%     th/length(thetas)
    
    realtheta = thetas(th);
    
%     if th < 16
%         compstep = 0.00001;
%     else
%         compstep = 0.0001;
%     end
    
    % here we obtain the post-refraction thetas and omegas
    
    theta = (pi/2) - asin((sin((pi/2) - realtheta))/(n2));
    
    if n2 == 1 && abs(theta - realtheta) > 0.0001
        input('wait');
    end
   
% A quadratic implementation that works with n2 = 1
%     K = 2/tan(theta);
%     t = tan(omega);
%     mb = 2 + K*t;
%     d = mb^2 - (4*t*(K-t));
%     mytmptheta1 = atan((mb - sqrt(d))/(2*t));
    
    tmptheta = 0.01; 
    ttcount = 1;
    ttcount2 = 1;
    
    clear score1 score2;
    clear thetavals;
    
    while tmptheta <= pi/2 && abs(tmptheta+realomega)<=pi/2
        
%         if th < 16
%         
% %         tmptheta/(pi/2)
%         
%         end
        
        if (realomega + tmptheta) < (pi/2)
        
            tmpsin1 = sin(tmptheta + realomega);
            tmpsin2 = sin(tmptheta);
            score1(ttcount) = abs( (2/tan(theta)) - ((tmpsin1)/(sqrt((n2)^2 - (tmpsin1)^2))) - ((tmpsin2)/(sqrt((n2)^2 - (tmpsin2)^2))) );
            thetavals1(ttcount) = tmptheta;
            ttcount = ttcount + 1;
            
        end
        
        
        if (realomega - tmptheta) > 0
            tmpsin1 = sin(realomega - tmptheta);
            tmpsin2 = sin(tmptheta);
            score2(ttcount2) = abs( (2/tan(theta)) - ((tmpsin1)/(sqrt((n2)^2 - (tmpsin1)^2))) + ((tmpsin2)/(sqrt((n2)^2 - (tmpsin2)^2))) );
            thetavals2(ttcount2) = tmptheta;
            ttcount2 = ttcount2 + 1;
        end
        
        tmptheta = tmptheta + compstep;
    end
    
    f1 = find(score1 == min(score1(:)));
    f2 = find(score2 == min(score2(:))); 
    
    tmptheta1 = thetavals1(f1(1));
    tmptheta2 = realomega + tmptheta1;
    
    tmptheta1_p = asin((sin(tmptheta1))/(n2));
    tmptheta2_p = asin((sin(tmptheta2))/(n2));
    
    omega1 = tmptheta2_p - tmptheta1_p;
    
    tmptheta12 = thetavals2(f2(1));
    tmptheta22 = realomega - tmptheta12;
    
    tmptheta12_p = asin((sin(tmptheta12))/(n2));
    tmptheta22_p = asin((sin(tmptheta22))/(n2));
    
    omega2 = tmptheta22_p + tmptheta12_p;   
    
    if min(score1(:)) < min(score2(:))
        omega = omega1;
        omegachoice = 1;
        mytheta1 = tmptheta1_p;
        mytheta2 = tmptheta2_p;
    else
        omega = omega2;
        omegachoice = 2;
        mytheta1 = tmptheta12_p;
        mytheta2 = tmptheta22_p;
    end
    
    if n2 == 1 && abs(omega - realomega) > 0.0001
        input('wait');
    end
    
    A = (cos(omega))^2 + ((cos(omega))^2)*((cot(theta))^4) + 2*((cot(theta))^2)*((cos(omega))^2) - (csc(theta))^4;
    
    B = ((cos(omega))^2)*((d^2)/2) - ((cos(omega))^2)*((cot(theta))^2)*((d^2)/2) +  ((csc(theta))^2)*((d^2)/2);
    
    C = ((cos(omega))^2)*((d^4)/16) - ((d^4)/16);
    
%     As(th) = A;
%     
%     Bs(th) = B;
%     
%     Cs(th) = C;
%         
    % obtain v
    
    if (B^2 - 4*A*C >= 0)
        
        thedet1 = (-1*B + sqrt(B^2 - 4*A*C))/(2*A);
        thedet2 = (-1*B - sqrt(B^2 - 4*A*C))/(2*A);

        valid = 0;
        
        if thedet1 > 0

                v = sqrt(thedet1);
                
                ndiff = n - n2;
                if abs(ndiff) < 0.00001
                    ndiff = 0;
                end

                    % This is changes to include the immersion media
                    R = ((ndiff)*v*u)/((n2)*(v + u));     
                    f = (R*n2)/(ndiff);
                
                x = u*cot(theta);
                
                if u >= 2*f
                    if v <= 2*f
                        valid = 1;
                    end
                end

                if u <= 2*f
                    if v >= 2*f
                        valid = 1;
                    end
                end
                
                if d > 2*R
                    valid = 0;
                end
  
                if valid

                     xp = (v*x)/u;
                     a = sqrt(v^2 + (xp + (d/2))^2);
                     b = sqrt(v^2 + (xp - (d/2))^2);
       
                     newomega = acos((a^2 + b^2 - d^2)/(2*a*b));                     
                     
                     if abs(newomega - omega) < 0.00001
                            lenses(count,:) = [f R v x th omegachoice omega theta mytheta1 mytheta2];
                            count = count + 1;
                     end
                    
                end

        end

        if thedet2 > 0
                
                v = sqrt(thedet2);
                
                ndiff = n - n2;
                if abs(ndiff) < 0.00001
                    ndiff = 0;
                end

                % This is changes to include the immersion media

                    R = ((ndiff)*v*u)/((n2)*(v + u));     
                    f = (R*n2)/(ndiff);
                
                x = u*cot(theta);

                if u >= 2*f
                    if v <= 2*f
                        valid = 1;
                    end
                end

                if u <= 2*f
                    if v >= 2*f
                        valid = 1;
                    end
                end
                
                if d > 2*R
                    valid = 0;
                end
                
                if valid

                     xp = (v*x)/u;
                     a = sqrt(v^2 + (xp + (d/2))^2);
                     b = sqrt(v^2 + (xp - (d/2))^2);
       
                     newomega = acos((a^2 + b^2 - d^2)/(2*a*b));
                     if abs(newomega - omega) < 0.00001
                            lenses(count,:) = [f R v x th omegachoice omega theta mytheta1 mytheta2];
                            count = count + 1;
                     end
                    
                end

        end
            
    end
    
end

% now calculate how much play is there in each lens
% This is the optimization mentioned in the paper, that finds the design
% with the best eFOV  
for i = 1:count-1
% for i = 38:39

    
    costsl = [];
    costsr = [];
    lomegas = [];
    romegas = [];
    
%     i/(count-1)
    
    cost = 0;
    % do the positive
    
%     step = 0.1;
    right = lenses(i,4);
    v = lenses(i,3);
    theta = lenses(i,8);
    
    xp = (v*right)/u;
    
    a = sqrt(v^2 + (xp + (d/2))^2);
    b = sqrt(v^2 + (xp - (d/2))^2);
       
    newomega_p = acos((a^2 + b^2 - d^2)/(2*a*b));
       
    % we have to calculate the omega from this
    
%     newomega_p
%     theta
%     right
%     input('wait')
    
    if (lenses(i,6) == 1)
    
       K = 2/tan(theta);
       t = tan(newomega_p);
       mb = 2 + K*t;
       dt = mb^2 - (4*t*(K-t));
       
       mytheta1_p1 = atan((mb + sqrt(dt))/(2*t));
       mytheta2_p1 = newomega_p + mytheta1_p1;
       
       mytheta1_p2 = atan((mb - sqrt(dt))/(2*t));
       mytheta2_p2 = newomega_p + mytheta1_p2;
       
       if mytheta2_p1 > pi/2
           t1 = mytheta1_p2;
           t2 = mytheta2_p2;
       elseif mytheta2_p2 > pi/2
           t1 = mytheta1_p1;
           t2 = mytheta2_p1;
       else
           input('help!')
       end
       
       t1r = asin(n2*sin(t1));
       t2r = asin(n2*sin(t2));
       newomega = t2r - t1r;
       
    else
        
       K = 2/tan(theta);
       t = tan(newomega_p);
       mb = -1*(2 + K*t);
       dt = mb^2 - 4*t*(K - t);
       
       mytheta1_p1 = atan((mb + sqrt(dt))/(2*t));
       mytheta2_p1 = newomega_p - mytheta1_p1;
       
       mytheta1_p2 = atan((mb - sqrt(dt))/(2*t));
       mytheta2_p2 = newomega_p - mytheta1_p2;

       if mytheta2_p1 > pi/2
           t1 = mytheta1_p2;
           t2 = mytheta2_p2;
       elseif mytheta2_p2 > pi/2
           t1 = mytheta1_p1;
           t2 = mytheta2_p1;
       else
           input('help!')
       end
       
       t1r = asin(n2*sin(t1));
       t2r = asin(n2*sin(t2));
       newomega = t2r + t1r;
            
    end
    
    if n2 == 1 && abs(newomega - omega) > 0.0001
        input('wait');
    end
    
    flagreal = isreal(newomega);
    
%     i
%     count
%     flagreal
%     newomega
%     realomega
%     input('wait')
    
    if flagreal && abs(newomega - realomega) > 0.01
        input('wait');
    end
    
           
%        atan(v/xp)
%        thetas(lenses(i,end))
%        
%        newomega
%        omega
    
    tcost = 1;
    costsr = [];
    rocount = 1;
    
    % while cost < maxcost && right < maxstep
    while flagreal && cost < maxcost 
       right = right + step;
       
       xp = (v*right)/u;
       a = sqrt(v^2 + (xp + (d/2))^2);
       b = sqrt(v^2 + (xp - (d/2))^2);
                     
       % update theta 
       theta = atan(v/xp);
       
       newomega_p = acos((a^2 + b^2 - d^2)/(2*a*b));
       
       % we have to calculate the omega from this
       
%         if (lenses(i,6) == 1)

       K = 2/tan(theta);
       t = tan(newomega_p);
       mb = 2 + K*t;
       dt = mb^2 - (4*t*(K-t));

       mytheta1_p1 = atan((mb + sqrt(dt))/(2*t));
       mytheta2_p1 = newomega_p + mytheta1_p1;

       mytheta1_p2 = atan((mb - sqrt(dt))/(2*t));
       mytheta2_p2 = newomega_p + mytheta1_p2;

       if mytheta2_p1 > pi/2
           t1 = mytheta1_p2;
           t2 = mytheta2_p2;
       elseif mytheta2_p2 > pi/2
           t1 = mytheta1_p1;
           t2 = mytheta2_p1;
       else
           input('help!')
       end
       
       if t1 >= 0 & t2 >= 0

           t1r = asin(n2*sin(t1));
           t2r = asin(n2*sin(t2));
           newomega = t2r - t1r;

        else

           K = 2/tan(theta);
           t = tan(newomega_p);
           mb = -1*(2 + K*t);
           dt = mb^2 - 4*t*(K - t);

           mytheta1_p1 = atan((mb + sqrt(dt))/(2*t));
           mytheta2_p1 = newomega_p - mytheta1_p1;

           mytheta1_p2 = atan((mb - sqrt(dt))/(2*t));
           mytheta2_p2 = newomega_p - mytheta1_p2;

           if mytheta2_p1 > pi/2
               t1 = mytheta1_p2;
               t2 = mytheta2_p2;
           elseif mytheta2_p2 > pi/2
               t1 = mytheta1_p1;
               t2 = mytheta2_p1;
           else
               input('help!')
           end
           
           if t1 < 0 & t2 < 0
               input('less');
           end

           t1r = asin(n2*sin(t1));
           t2r = asin(n2*sin(t2));
           newomega = t2r + t1r;

        end
        
        if n2 == 1 && abs(newomega - newomega_p) > 0.0001
            input('wait');
        end
        
        if isreal(newomega)
            
            cost = abs(newomega - realomega);
            costsr(tcost) = cost;
            tcost = tcost + 1;
       
            romegas(rocount,:) = [newomega_p newomega];
            rocount = rocount + 1;
            
        else
            
            cost = maxcost;
            
        end
       
        if cost >= maxcost
            right = right - step;
        end
       
    end
    
        
%     right
%     input('wait')
              
    cost = 0;
    costsl = [];
    tcost = 1;
    left = lenses(i,4);
    locount = 1;
    % do the negative
%     while cost < maxcost && abs(left) < maxstep
    while flagreal && cost < maxcost
        
%     if i == 30 & abs(left - 0.2268) < 0.001
%         input('wait')
%     end
        
       left = left - step;
       
       xp = (v*abs(left))/u;
       a = sqrt(v^2 + (xp + (d/2))^2);
       b = sqrt(v^2 + (xp - (d/2))^2);
       
       % update theta 
       theta = atan(v/xp);
       
       newomega_p = acos((a^2 + b^2 - d^2)/(2*a*b));
       
       % we have to calculate the omega from this
       
%         if (lenses(i,6) == 1)

       K = 2/tan(theta);
       t = tan(newomega_p);
       mb = 2 + K*t;
       dt = mb^2 - (4*t*(K-t));

       mytheta1_p1 = atan((mb + sqrt(dt))/(2*t));
       mytheta2_p1 = newomega_p + mytheta1_p1;

       mytheta1_p2 = atan((mb - sqrt(dt))/(2*t));
       mytheta2_p2 = newomega_p + mytheta1_p2;

       if mytheta2_p1 > pi/2
           t1 = mytheta1_p2;
           t2 = mytheta2_p2;
       elseif mytheta2_p2 > pi/2
           t1 = mytheta1_p1;
           t2 = mytheta2_p1;
       else
           input('help!')
       end
       
       if t1 >= 0 & t2 >= 0
           
            t1r = asin(n2*sin(t1));
            t2r = asin(n2*sin(t2));
            newomega = t2r - t1r;

       else

           K = 2/tan(theta);
           t = tan(newomega_p);
           mb = -1*(2 + K*t);
           dt = mb^2 - 4*t*(K - t);

           mytheta1_p1 = atan((mb + sqrt(dt))/(2*t));
           mytheta2_p1 = newomega_p - mytheta1_p1;

           mytheta1_p2 = atan((mb - sqrt(dt))/(2*t));
           mytheta2_p2 = newomega_p - mytheta1_p2;

           if mytheta2_p1 > pi/2
               t1 = mytheta1_p2;
               t2 = mytheta2_p2;
           elseif mytheta2_p2 > pi/2
               t1 = mytheta1_p1;
               t2 = mytheta2_p1;
           else
               input('help!')
           end
           
           if t1 < 0 & t2 < 0
               input('less');
           end

           t1r = asin(n2*sin(t1));
           t2r = asin(n2*sin(t2));
           newomega = t2r + t1r;

        end
        
        if n2 == 1 && abs(newomega - newomega_p) > 0.0001
            input('wait');
        end
        
        if isreal(newomega)
       
            cost = abs(newomega - realomega);
            costsl(tcost) = cost;
            tcost = tcost + 1;
       
            lomegas(locount,:) = [newomega_p newomega];
            locount = locount + 1;
            
        else
            
            cost = maxcost;
            
        end
       
       if cost >= maxcost
            left = left + step;
       end

       
    end
    
        
%     left
%     input('wait')
    
    if (left <= 0 && right <= 0) | (left > 0 & right > 0)
        
        tmp1 = n2*sind(atand(abs(left)/u));
        tmp2 = n2*sind(atand(abs(right)/u));

        leftang = asind(tmp1);      
        rightang = asind(tmp2);        
        ang = abs(rightang) - abs(leftang);
        
%         leftang = atand(abs(left)/u);
%         rightang = atand(abs(right)/u);
        
        base = abs(abs(left) - abs(right));
        
        % angles for the links
        leftext = atand(abs((abs(left) + d/2)/u));
        lside = u*secd(leftext);    
        rightext = atand(abs((abs(right) - d/2)/u));
        rside = u*secd(rightext);
        
    else
        
        tmp1 = n2*sind(atand(abs(left)/u));
        tmp2 = n2*sind(atand(abs(right)/u));

        leftang = -1*asind(tmp1);      
        rightang = asind(tmp2);        
        ang = abs(rightang) + abs(leftang);
        
%         leftang = -1*atand(abs(left)/u);
%         rightang = atand((right)/u);
        
        base = abs(abs(left) + abs(right));
        
        % angles for the links
        leftext = atand(abs((abs(left) - d/2)/u));
        lside = u*secd(leftext);
        rightext = atand(abs((abs(right) - d/2)/u));
        rside = u*secd(rightext);
        
    end
    
    lensplay(i,:) = [(right - left) left right ang leftang rightang base leftext rightext lside rside];
    
    if flagreal
    
        bigcostsl{i} = costsl;
        bigcostsr{i} = costsr;
    
        lo{i} = lomegas;
        ro{i} = romegas;
        
    end
    
end

if exist('lensplay') == 1
    
    
%     input('wait')

    FOV = max(lensplay(:,4));

    tmp = lensplay(:,4);
    tmpf = find(tmp==max(tmp(:)));

    NumPixels = lensplay(tmpf(1),1)/step;

%     plot(thetas(lenses(:,5))*180/pi,lensplay(:,4));
%     hold
%     plot(thetas(lenses(:,5))*180/pi,dtheta*ones(size(1:size(lensplay,1))),'r')

% figure
% plot(thetas(lenses(:,5))*180/pi,lensplay(:,1)/step);

    t1 = lensplay(:,4);

    % realomega*180/pi
%     n
%     n2
%     FOV
%     NumPixels
%     FOV/NumPixels
%     find(t1 == max(t1(:)))
    % f = find(t1 ~= 0);
    % if ~isempty(f)
    %     f(1)
    % end
    focals = lenses(:,1);
    f = find(t1 == max(t1(:)));
    
    for f = 1:1:size(lensplay,1)
    
    % focals(f(1))
    tmp1 = lenses(f(1),:);
    tmp2 = lensplay(f(1),:);
    
%      lenses(count,:) = [f R v x th omegachoice omega theta mytheta1 mytheta2];
%  lensplay(i,:) = [(right - left) left right ang leftang rightang base leftext rightext lside rside];
    
    lookuptable_1(mystuffcount,:) = [n n2 u d tmp1(2) tmp2(4) tmp1(3) tmp2(1)/step];
    mystuffcount = mystuffcount + 1;
    
    end
        
%     input('wait');

else
    
%     n
%     
%     n2
%     
%     'no valid lenses'
    
%     pause(2)
    
end





% tmpt1(icount,:) = t1(1:100);
% icount = icount + 1;


close all
clear lensplay lenses

end
end

end
end

% end
